/*
 * DecisionTree.java
 *   Christopher Hammack (chammack@cse.unl.edu) 
 *   Implements the DecisionTree Learning algorithm class
 *
 *
 */

import java.io.*;
import java.util.Vector;
import java.util.StringTokenizer;

/**
 *
 * @author  cnh
 * @version 
 */

public class DecisionTree implements java.io.Serializable {

	private Node root;
	private DataSet ds;

	/** Creates new DecisionTree */
	public DecisionTree(int numFeatures) {
		ds = new DataSet(numFeatures);
	}



	public String classifyExample(Float[] vals) {
		Node ptr = root;
		String attributeStr;
		Float exampleValue;

		while (true) {
			attributeStr = ptr.getLabel();
			if (ptr.isTerminal()) 
				return attributeStr;

			Integer attribute = new Integer(Integer.parseInt(attributeStr));
			exampleValue = (Float) vals[attribute.intValue()];
						
			int index = ptr.indexOfChild(exampleValue);
                        if(index==-1) 
                                return ptr.getChild(0).getLabel(); 
			ptr = ptr.getChild(index);

		}
	}

	// Recursive starter to Build the tree based on the dataset 
	public void buildTree() {
		root = new Node(); // instantiate the root
		this.buildTree(ds, root); // call recursive starter call
	}

	public void add(Float[] features, String label) {
		ds.add(features, label);
	}
	
	// BuildTree recursive call    
	public void buildTree(DataSet relds, Node relroot) {
		if (relds == null || relds.getSize() == 0) { // No examples!  should never happen
			// should handle this better
			relroot.setLabel("UNKNOWN");
			return;
		}
		
		// uniform label checks to see if all nodes in the dataset have same label
		//   if so, we just label the current node and we're done.
		String uniformLabel = relds.uniformLabel();

		if (!uniformLabel.equals("")) {
			relroot.setLabel(uniformLabel);
			return;
		}

		int k = relds.calcInfoGain();
		// I "label" internal tree nodes with the index of the feature vector
		//  (which feature provides max info gain).  
		relroot.setLabel("" + k);

		double IG = relds.getIG();
		// if max IG = 0, pick the majority and label it.
		if (IG == 0.0) {
			String majorityLabel = relds.majorityLabel();
			relroot.setLabel(majorityLabel);
			return;
		}

		int branchFactor = relds.getBranchFactor();
		for (int i = 0; i < branchFactor; i++) {
			// Get the value of the branch
			Float value = relds.getBranchValue(i);
			DataSet subds;
			Node n = new Node(); // instantiate a child node
			relroot.addChild(n, value); // Link the node with the corresponding v_i
			subds = relds.getSubset(i); // get the partition dataset
			if (subds == null)
				System.out.println("We have a problem");

			buildTree(subds, n); // call recursively on subtree
		}
	}
}
