
import java.io.*;

/**
 * @author cnh
 *
 */
public class ID3Learner implements MyLearner {

	private DecisionTree dt;
	private int numFeatures;
	private String myName;

	public ClassifyResult classify(Object[] feature) throws Exception {
		Float[] floatFeature = (Float[]) feature;
		String label = dt.classifyExample(floatFeature);
		
		ClassifyResult cr = new ClassifyResult();
		cr.confidences = new float[1];
		cr.labels = new String[1];
		cr.confidences[0] = (float) 1.0; // (100% confidence)
		cr.labels[0] = label;
		return cr;
	}

	public void classifyStart(String name) throws Exception {
		try {
			FileInputStream fis = new FileInputStream(name + ".obj");
			ObjectInputStream ois = new ObjectInputStream(fis);

			dt = (DecisionTree) ois.readObject();
			ois.close();
			fis.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw new java.lang.Exception("IOException");
		}
	}

	public void classifyStop() throws Exception {
		return;
	}


	public byte[] exportClassifier(String name) throws Exception {
		return new byte[1];
	}

	public ExtractionResult extract(Object[] feature) throws Exception {
		throw new Exception("NotImplementedException");
		// DO NOT IMPLEMENT
	}

	public long getClassifierAge(String name) throws Exception {
		return 0;
		//	DO NOT IMPLEMENT
	}


	public void importClassifier(String name, byte[] data) throws Exception {
		//	DO NOT IMPLEMENT
		return;
	}


	public void setOption(String attribute, String value) throws Exception {
		// TODO Auto-generated method stub
		if(attribute.equals("attribute_count"))
			numFeatures = Integer.parseInt(value);
	}


	public void train(Object[] feature, String label) throws Exception {
		Float[] floatFeature = (Float[]) feature;
		dt.add(floatFeature, label);
	}


	public void train(Object[] feature, String[] attributes, int attribcount)
		throws Exception {
		throw new Exception("NotImplementedException");
		// DO NOT IMPLEMENT
	}


	public void trainStart(String name) throws Exception {
		myName = name;
		dt = new DecisionTree(numFeatures); // numFeatures comes from setOption
	}


	public void trainStop() throws Exception {
		dt.buildTree();
		try {
		   FileOutputStream fos = new FileOutputStream(myName + ".obj");
		   ObjectOutputStream oos = new ObjectOutputStream(fos);
		   oos.writeObject(dt);
		}
		catch(Exception e) {
		   e.printStackTrace();
		   throw new Exception("IOException");
		}
	}

}
