import java.util.Vector;

/*
 * Node.java
 *   Abstract class for storing the nodes of our tree.
 *   Supports variable branch factors.
 */

/**
 *
 * @author  cnh
 * @version 
 */
public class Node implements java.io.Serializable {

	private String attribute;
	private boolean isTerminal;
	private Vector children = new Vector();
	private Vector values = new Vector();

	/** Creates new Node */
	public Node() {
		attribute = "";
		isTerminal = true; // all nodes start out terminal
	}

	public Node(String inAttribute, int branchFactor) {
		attribute = inAttribute;
		isTerminal = true; // all nodes start out terminal
	}

	public void setLabel(String inAttribute) {
		attribute = inAttribute;
	}

	public void addChild(Node n, Float value) {
		isTerminal = false; // no longer terminal
		children.add(n);
		values.add(value);
	}

	public Node getChild(int i) {
		return (Node) children.get(i);
	}

	public int indexOfChild(Float value) {
		return values.indexOf(value);
	}
	
	public int getChildCount() {
		return children.size();
	}

	public String getLabel() {
		return attribute;
	}

	public boolean isTerminal() {
		return isTerminal;
	}

}
